package gov.va.vinci.dart.rest;

import java.util.HashMap;

import org.apache.commons.lang.StringUtils;

public class RestQuery {
	HashMap<String,String> terms = new HashMap<String,String>();
	
	public RestQuery(final String queryString) {
		if (StringUtils.isNotEmpty(queryString)) {
			String[] parts = queryString.split("&");
			for (String p : parts) {
				if (StringUtils.isNotEmpty(p)) {
					String[] kvp = p.split("=");
					if (kvp.length == 2) {
						terms.put(kvp[0], kvp[1]);
					}
				}
			}
		}
	}
	
	public boolean isEmpty() {
		return terms.size() == 0;
	}
	
	public String getTerm(final String key) {
		return terms.get(key);
	}
}
